/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base;

import filenet.vw.base.VWLogger;
import java.io.PrintStream;

public class VWDebug {
    private static VWLogger s_logger = null;

    public static String _get_FILE_DATE() {
        return "$Date:   25 Jan 2005 08:54:10  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   dmcphee  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.2  $";
    }

    public static void init(PrintStream stream, int logLevel) {
        try {
            s_logger.setDebugStream(stream, logLevel);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public static void init(int logLevel) {
        VWDebug.init(System.err, logLevel);
    }

    public static void setLogFile(String fileName, int logLevel) {
        try {
            s_logger.setFileToLog(fileName, logLevel);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public static void logException(Exception e, String extraInformation) {
        try {
            if (s_logger != null) {
                s_logger.logException(e, extraInformation);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    public static void logException(Exception e) {
        try {
            if (s_logger != null) {
                s_logger.logException(e, null);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    public static void logError(String info) {
        try {
            if (s_logger != null) {
                s_logger.log(VWLogger.ERROR, info);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    public static void logWarning(String info) {
        try {
            if (s_logger != null) {
                s_logger.log(VWLogger.WARNING, info);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    public static void logInfo(String info) {
        try {
            if (s_logger != null) {
                s_logger.log(VWLogger.INFORMATION, info);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    public static boolean nullCheck(Object theObject) {
        if (s_logger != null) {
            try {
                return s_logger.nullCheck(theObject);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
        }
        return theObject != null;
    }

    static {
        try {
            s_logger = new VWLogger();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

